<?php


function zanna_theme_register_required_plugins() {

  $plugins = array(

    'kitify' => array(
      'name'               => esc_html__('Kitify','zanna'),
      'slug'               => 'kitify',
      'source'             => 'http://assets.novaworks.net/plugins/kitify.zip',
      'required'           => true,
      'description'        => esc_html__('A perfect plugin for Elementor','zanna'),
      'demo_required'      => true,
      'version'            => '1.2.2'
    ),
    'zanna-core' => array(
      'name'               => esc_html__('Zanna Core','zanna'),
      'slug'               => 'zanna-core',
      'source'             => 'http://assets.novaworks.net/plugins/zanna-core.zip',
      'required'           => true,
      'description'        => esc_html__('Extends the functionality of Zanna with theme specific shortcodes and page builder elements.','zanna'),
      'demo_required'      => true,
      'version'            => '1.0.1'
    ),
    'elementor' => array(
      'name'               => esc_html__('Elementor Page Builder','zanna'),
      'slug'               => 'elementor',
      'required'           => true,
      'description'        => esc_html__('The most advanced frontend drag & drop page builder. Create high-end, pixel perfect websites at record speeds. Any theme, any page, any design.','zanna'),
      'demo_required'      => true
    ),
    'wc-ajax-product-filter' => array(
      'name'               => esc_html__('Nova Ajax Product Filters','zanna'),
      'slug'               => 'nova-ajax-product-filter',
      'source'             => 'http://assets.novaworks.net/plugins/nova-ajax-product-filter.zip',
      'required'           => true,
      'description'        => esc_html__('A plugin to filter woocommerce products with AJAX request.','zanna'),
      'demo_required'      => true,
      'version'            => '1.0.2'
    ),
    'woocommerce' => array(
      'name'               => esc_html__('WooCommerce','zanna'),
      'slug'               => 'woocommerce',
      'required'           => true,
      'description'        => esc_html__('The eCommerce engine','zanna'),
      'demo_required'      => true
    ),
    'revslider' => array(
      'name'               => esc_html__('Slider Revolution','zanna'),
      'slug'               => 'revslider',
      'source'				     => 'http://assets.novaworks.net/plugins/revslider.zip',
      'required'           => false,
      'version'            => '6.7.37',
      'demo_required'      => true
    ),
    'zanna-demo-data' => array(
      'name'               => esc_html__('Zanna Package Demo Data','zanna'),
      'slug'               => 'zanna-demo-data',
      'source'				     => 'http://assets.novaworks.net/plugins/zanna/zanna-demo-data.zip',
      'required'           => false,
      'demo_required'      => true
    ),
    'woo-variation-swatches' => array(
      'name'               => esc_html__('Variation Swatches for WooCommerce','zanna'),
      'slug'               => 'woo-variation-swatches',
      'required'           => false,
      'description'        => esc_html__('Beautiful colors, images and buttons variation swatches for woocommerce product attributes. Requires WooCommerce 3.2+','zanna'),
      'demo_required'      => true
    ),
    'yith-woocommerce-wishlist' => array(
      'name'               => esc_html__('YITH WooCommerce Wishlist','zanna'),
      'slug'               => 'yith-woocommerce-wishlist',
      'required'           => false,
      'description'        => esc_html__('YITH WooCommerce Wishlist gives your users the possibility to create, fill, manage and share their wishlists allowing you to analyze their interests and needs to improve your marketing strategies.','zanna'),
      'demo_required'      => true
    ),
    'envato-market' => array(
      'name'               => esc_html__('Envato Market','zanna'),
      'slug'               => 'envato-market',
      'source'             => 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
      'required'           => false,
      'description'        => esc_html__('Automatically update your Envato theme','zanna'),
      'demo_required'      => true
    ),
  );

	$config = array(
	  'id'                => 'zanna',
		'default_path'      => '',
		'parent_slug'       => 'themes.php',
		'menu'              => 'tgmpa-install-plugins',
		'has_notices'       => true,
		'is_automatic'      => true,
	);

	tgmpa( $plugins, $config );
}

add_action( 'tgmpa_register', 'zanna_theme_register_required_plugins' );
