<?php

$opt_name = NOVA_FRAMEWORK_VAR;

$primary_color = '#111111';
$titles_color = '#111111';
$text_color = '#777777';
$border_color = '#ECECEC';
$input_bg_color = '#FFFFFF';
$background_color = '#FFFFFF';
$content_bg_color = '#FFFACD';
$black = '#000000';
$white = '#FFFFFF';
$s_button_color = '#222222';
$header_notice_color = '#000000';
/* Blog */

CSF::createSection( $opt_name, array(
	'title' => esc_html__('Styling', 'zanna-core'),
    'icon' => 'fa fa-pencil',
    'id' => 'styling'
) );

/* Basic Styling */

CSF::createSection( $opt_name, array(
	'title' => esc_html__('Basic Styling', 'zanna-core'),
    // 'icon' => 'el-icon-pencil',
    'parent' => 'styling',
	'fields' => array(
				array(
					'id' => 'bg_color',
					'type' => 'color',
					'title' => esc_html__('Body Background Color ', 'zanna-core'),
					'default' => $background_color,
					'subtitle' =>  esc_html__("Default: ".$background_color, 'zanna-core'),
								'desc' =>  esc_html__('Body background color', 'zanna-core'),
								'transparent' => false,
								'class' => 'nova-hide-transparent',
								'validate' => 'csf_validate_hex_color_transparent',
				),
      array(
				'id' => 'primary_color',
				'type' => 'color',
				'title' => esc_html__('Primary color ', 'zanna-core'),
				'default' => $primary_color,
				'subtitle' =>  esc_html__("Default: ".$primary_color, 'zanna-core'),
	            'desc' =>  esc_html__('Accent color', 'zanna-core'),
	            'transparent' => false,
	            'class' => 'nova-hide-transparent',
	            'validate' => 'csf_validate_hex_color_transparent',
		),

    array(
			'id' => 'titles_color',
			'type' => 'color',
			'title' => esc_html__('Titles Color', 'zanna-core'),
			'default' => $titles_color,
			'subtitle' =>  esc_html__("Default: ".$titles_color, 'zanna-core'),
            // 'desc' =>  esc_html__('Buttons, main links, etc', 'zanna-core'),
			// 'validate' => 'color',
            'transparent' => false,
            'class' => 'nova-hide-transparent',
            'validate' => 'csf_validate_hex_color_transparent',
		),
		array(
			'id' => 'text_color',
			'type' => 'color',
			'title' => esc_html__('Text Color', 'zanna-core'),
			'default' => $text_color,
			'subtitle' =>  esc_html__("Default: ".$text_color, 'zanna-core'),
			//'validate' => 'color',
            'transparent' => false,
            'class' => 'nova-hide-transparent',
            'validate' => 'csf_validate_hex_color_transparent',
        ),
		array(
			'id' => 'border_color',
			'type' => 'color',
			'title' => esc_html__('Border Color', 'zanna-core'),
			'default' => $border_color,
			'subtitle' =>  esc_html__("Default: ".$border_color, 'zanna-core'),
			//'validate' => 'color',
            'transparent' => false,
            'class' => 'nova-hide-transparent',
            'validate' => 'csf_validate_hex_color_transparent',
        ),
	)
) );
/* Buttons */

CSF::createSection( $opt_name, array(
	'title' => esc_html__('Buttons/Links', 'zanna-core'),
    // 'icon' => 'el-icon-edit',
    'parent' => 'styling',
	'fields' => array(
        array(
			'id' => 'content_link_color',
			'type' => 'link_color',
			'title' => esc_html__('General link color', 'zanna-core'),
			'subtitle' => esc_html__("Default: $black, Hover: $primary_color", 'zanna-core'),
			// 'validate' => 'color',
			'active' => false,
			'default' => array(
				'color' => $black,
                'hover' => $text_color,
			),
            'class' => 'nova-hide-transparent',
        ),
        array(
			'id' => 'primary_button',
			'type' => 'color_group',
			'title' => esc_html__('Primary Button', 'zanna-core'),
			'default' => $white,
            'subtitle' => esc_html__("Default: $black, Text: $white", 'zanna-core'),
            'transparent' => false,
            // 'validate' => 'csf_validate_hex_color',
            'class' => 'nova-hide-transparent',
            'options' => array(
                'background' => 'Background',
                'text_color' => 'Text Color',
            ),
            'default' => array(
                'background' => $black,
                'text_color' => $white,
            )
        ),
        array(
			'id' => 'secondary_button',
			'type' => 'color_group',
			'title' => esc_html__('Secondary Button', 'zanna-core'),
			'default' => $s_button_color,
            'subtitle' => esc_html__("Default: $black, Text: $white", 'zanna-core'),
            'transparent' => false,
            // 'validate' => 'csf_validate_hex_color',
            'class' => 'nova-hide-transparent',
            'options' => array(
                'background' => 'Background',
                'text_color' => 'Text Color',
            ),
            'default' => array(
                'background' => $s_button_color,
                'text_color' => $white,
            )
        ),
		array(
			'id' => 'button_radius',
						'type' => 'slider',
			'title' => esc_html__('Button radius', 'zanna-core'),
			'desc' => esc_html__('Default: 0 pixels.', 'zanna-core'),
			'default' => '0',
			'min' => '0',
			'step' => '1',
						'max' => '100',
						'unit' => 'px',
		),
	)
) );


/* Forms */

CSF::createSection( $opt_name, array(
	'title' => esc_html__('Forms', 'zanna-core'),
    // 'icon' => 'el-icon-edit',
    'parent' => 'styling',
	'fields' => array(
        array(
            'id'   => 'info_forms',
            'type' => 'subheading',
            'title' => esc_html__('Important:', 'zanna-core'),
            'subtitle' => esc_html__('All these options affects contact and comments form.', 'zanna-core')
        ),
		array(
			'id' => 'field_radius',
						'type' => 'slider',
			'title' => esc_html__('Field radius', 'zanna-core'),
			'desc' => esc_html__('Default: 0 pixels.', 'zanna-core'),
			'default' => '0',
			'min' => '0',
			'step' => '1',
						'max' => '100',
						'unit' => 'px',
		),
        array(
			'id' => 'input_bg_color',
			'type' => 'color',
			'title' => esc_html__('Input box background color', 'zanna-core'),
			'default' => $input_bg_color,
            'subtitle' =>  esc_html__('Default: '.$input_bg_color, 'zanna-core'),
			// 'validate' => 'color',
			'transparent' => false
        ),
        array(
			'id' => 'input_text_color',
			'type' => 'color',
			'title' => esc_html__('Input box text color', 'zanna-core'),
			'default' => $text_color,
            'subtitle' =>  esc_html__('Default: '.$text_color, 'zanna-core'),
			// 'validate' => 'color',
			'transparent' => false
        ),
        array(
			'id' => 'label_text_color',
			'type' => 'color',
			'title' => esc_html__('Label text color', 'zanna-core'),
			'default' => $text_color,
            'subtitle' =>  esc_html__('Default: '.$text_color, 'zanna-core'),
			// 'validate' => 'color',
			'transparent' => false
        ),
        array(
			'id' => 'submit_bg_color',
			'type' => 'color',
			'title' => esc_html__('Submit button background color', 'zanna-core'),
			'default' => $primary_color,
            'subtitle' =>  esc_html__("Default: ".$primary_color, 'zanna-core'),
			// 'validate' => 'color',
            'transparent' => false,
            // 'class' => 'nova-hide-transparent',
            'validate' => 'csf_validate_hex_color',
        ),
        array(
			'id' => 'submit_text_color',
			'type' => 'color',
			'title' => esc_html__('Submit button text color', 'zanna-core'),
			'default' => $white,
            'subtitle' =>  esc_html__('Default: '.$white, 'zanna-core'),
			// 'validate' => 'color',
			'transparent' => false
        ),
	)
) );

